using System;
using System.IO;
using System.Xml;
using System.Collections;

namespace Team_Project
{
	/// <summary>
	/// Questa interfaccia dev'essere implementata dagli oggetti che devono far
	/// parte della catena dei messaggi.
	/// </summary>
	public interface IOperationHandler
	{
		/// <summary>
		/// Esegue le operazioni adibite all'anello della catena
		/// </summary>
		/// <param name="data">Dati calcolati dai livelli precedenti</param>
		/// <param name="tr">Reader posizionato prima del primo nodo che interessa
		/// questo livello</param>
		/// <param name="ok">Parametro in uscita che indica la risuscita dell'operazione</param>
		/// <returns>Uno stream con il risultato della computazione di questo anello
		/// e di quelli successivi.</returns>
		Stream Compute(IDictionary data,XmlTextReader tr, out bool ok);
		/// <summary>
		/// Esegue le operazioni adibite all'anello della catena
		/// </summary>
		/// <param name="data">Dati calcolati dai livelli precedenti</param>
		/// <param name="fullXml">Stringa contenente l'intero xml della richiesta</param>
		/// <param name="ok">Parametro in uscita che indica la risuscita dell'operazione</param>
		/// <returns>Uno stream con il risultato della computazione di questo anello
		/// e di quelli successivi.</returns>
		string Compute(IDictionary data,string fullXml, out bool ok);
		/// <summary>
		/// Ottiene o imposta il token che identifica l'anello all'interno della catena
		/// </summary>
		object ChainToken
		{
			get;
			set;
		}
	}

	/// <summary>
	/// Interfaccia che dev'essere implementata da tutti i moduli funzionali
	/// di team project, ad esempio il modulo per la gestione dei files o dei
	/// messaggi
	/// </summary>
	public interface ITPModule
	{
		/// <summary>
		/// L'implementazione di questa funzione deve registrare sull'engine passato
		/// come parametro tutte le operazioni che desidera gestire.
		/// </summary>
		/// <param name="eng">Istanza dell'engine sulla quale effettuare la 
		/// registrazione</param>
		void RegisterOperations(TPEngine eng);
	}
}
